<?php
error_reporting(0);
ini_set('display_errors', 0);

// Bersihkan semua output buffer dulu biar header gak terganggu
if (ob_get_level()) ob_end_clean();
ob_start();

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

// ===== Validasi Kelas =====
$class_id = (int)($_GET['class_id'] ?? 0);
if (!$class_id) {
    die('Kelas belum dipilih.');
}

// ===== Ambil Data Kelas =====
$class = $conn->query("SELECT c.name AS class_name, g.name AS group_name, t.name AS tier_name
                       FROM classes c
                       JOIN class_groups g ON g.id = c.group_id
                       JOIN class_tiers t ON t.id = g.tier_id
                       WHERE c.id = $class_id")->fetch_assoc();

$class_name = $class ? "{$class['tier_name']} - {$class['group_name']} - {$class['class_name']}" : "Kelas Tidak Diketahui";

// ===== Header Export =====
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=Data_Siswa_{$class['class_name']}.xls");
header("Pragma: no-cache");
header("Expires: 0");

// ===== Output Tabel HTML agar Excel auto-format =====
echo "<table border='1'>";
echo "<tr><th colspan='6'>Data Siswa Kelas: {$class_name}</th></tr>";
echo "<tr>
        <th>No</th>
        <th>NIM</th>
        <th>Nama</th>
        <th>Tanggal Lahir</th>
        <th>Email</th>
        <th>WhatsApp</th>
      </tr>";

// ===== Ambil Data Siswa =====
$q = $conn->query("SELECT nim, name, birth_date, email, whatsapp FROM students WHERE class_id = $class_id ORDER BY name");

$no = 1;
while ($r = $q->fetch_assoc()) {
    $nim = "\t" . $r['nim']; 
    $birth = !empty($r['birth_date']) ? $r['birth_date'] : '-';
    $email = !empty($r['email']) ? $r['email'] : '-';
    $wa = !empty($r['whatsapp']) ? $r['whatsapp'] : '-';

    echo "<tr>
            <td>{$no}</td>
            <td>{$nim}</td>
            <td>{$r['name']}</td>
            <td>{$birth}</td>
            <td>{$email}</td>
            <td>{$wa}</td>
          </tr>";
    $no++;
}


echo "</table>";
exit;
