<?php
error_reporting(0);
ini_set('display_errors', 0);
ob_clean(); // pastikan tidak ada output HTML sebelum JSON

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
require __DIR__ . '/../../vendor/phpqrcode/qrlib.php';

header('Content-Type: application/json; charset=utf-8');

// --- Ambil parameter ---
$id = (int)($_GET['id'] ?? 0);
$duration = (int)($_GET['duration'] ?? 0);
$manual_date = $_GET['manual_date'] ?? null;

if (!$id) {
  echo json_encode(['success' => false, 'error' => 'ID siswa tidak valid.']);
  exit;
}

// --- Ambil data siswa ---
$q = $conn->query("SELECT nim, name FROM students WHERE id = $id LIMIT 1");
if (!$q || $q->num_rows === 0) {
  echo json_encode(['success' => false, 'error' => 'Data siswa tidak ditemukan.']);
  exit;
}

$s = $q->fetch_assoc();
$nim  = $s['nim'];
$name = preg_replace('/[^A-Za-z0-9]/', '_', $s['name']);

// --- Hitung tanggal expired ---
if ($manual_date) {
  $expireTime = date('Y-m-d 23:59:59', strtotime($manual_date));
} elseif ($duration >= 9999) {
  $expireTime = null; // Permanent
} else {
  $expireTime = date('Y-m-d H:i:s', strtotime("+$duration days"));
}

// --- Siapkan direktori ---
$dir = __DIR__ . '/../../qrcodes/';
if (!is_dir($dir)) mkdir($dir, 0777, true);

// --- Buat URL dan QR code ---
$baseURL = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}";
$url = $baseURL . "/system-absent/modules/absensi_kelas/scan_qr.php?nim=" . urlencode($nim);

$fileName = "{$nim}_" . time() . ".png";
$filePath = $dir . $fileName;

// Buat QR code
QRcode::png($url, $filePath, QR_ECLEVEL_L, 6);

// --- Simpan info expired ke DB ---
$expireSQL = $expireTime ? "'$expireTime'" : "NULL";
$conn->query("UPDATE students SET qr_expiry = $expireSQL WHERE id = $id");

// --- Kirim respons JSON ---
echo json_encode([
  'success' => true,
  'qr_url' => "$baseURL/system-absent/qrcodes/$fileName",
  'expiry' => $expireTime ? $expireTime : 'Permanent'
]);
exit;
?>

?>
