<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json; charset=utf-8');

// Ambil log untuk modul siswa
$q = $conn->query("
  SELECT 
    l.created_at AS time,
    l.action,
    COALESCE(u.nama, 'Tidak diketahui') AS operator
  FROM logs l
  LEFT JOIN users u ON u.id = l.user_id
  WHERE l.module = 'siswa'
  ORDER BY l.created_at DESC
  LIMIT 100
");

if (!$q) {
  echo json_encode([
    'success' => false,
    'error' => 'Query error: ' . $conn->error
  ]);
  exit;
}

$data = [];
while ($r = $q->fetch_assoc()) {
  $data[] = [
    'time' => $r['time'],
    'operator' => $r['operator'],
    'action' => $r['action']
  ];
}

echo json_encode(['success' => true, 'data' => $data], JSON_UNESCAPED_UNICODE);
exit;
?>
