<?php
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json; charset=utf-8');

// ==== Ambil parameter ====
$class_id = (int)($_GET['class_id'] ?? 0);
$limit    = (int)($_GET['limit'] ?? 25);
$page     = (int)($_GET['page'] ?? 1);

if ($class_id <= 0) {
  echo json_encode(['success' => false, 'error' => 'Kelas tidak valid']);
  exit;
}

if ($limit <= 0) $limit = 25;
if ($page <= 0) $page = 1;

$offset = ($page - 1) * $limit;

// ==== Hitung total siswa ====
$total_q = $conn->query("SELECT COUNT(*) AS total FROM students WHERE class_id = $class_id");
$total = ($total_q && $total_q->num_rows) ? (int)$total_q->fetch_assoc()['total'] : 0;

// ==== Ambil data siswa per halaman ====
$q = $conn->query("
  SELECT id, nim, name, birth_date, email, whatsapp, qr_expiry
  FROM students 
  WHERE class_id = $class_id
  ORDER BY name ASC
  LIMIT $limit OFFSET $offset
");

$data = [];
$now = time();

while ($r = $q->fetch_assoc()) {
  $statusText = '';
  $color = '';
  $tooltip = '';

  if (is_null($r['qr_expiry']) || $r['qr_expiry'] === '0000-00-00 00:00:00') {
    $statusText = 'Aktif';
    $color = 'bg-green-600';
    $tooltip = "title='QR aktif secara permanen'";
  } else {
    $expire = strtotime($r['qr_expiry']);
    if ($expire < $now) {
      $statusText = 'Kadaluarsa';
      $color = 'bg-red-600';
      $tooltip = "title='QR sudah kadaluarsa pada {$r['qr_expiry']}'";
    } else {
      $statusText = 'Aktif';
      $color = 'bg-green-500';
      $tooltip = "title='Berlaku sampai {$r['qr_expiry']}'";
    }
  }

  $r['qr_status'] = "<span $tooltip class='px-2 py-1 rounded-md text-white text-xs cursor-help $color'>$statusText</span>";
  $data[] = $r;
}

// ==== Ambil nama kelas (support tier UNIK tanpa group) ====
$kelas = $conn->query("
  SELECT 
    CONCAT(
      t.name,
      IF(g.name IS NOT NULL AND g.name != '', CONCAT(' - ', g.name), ''),
      CONCAT(' - ', c.name)
    ) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  WHERE c.id = $class_id
")->fetch_assoc();

$class_name = $kelas['class_name'] ?? '(Tidak diketahui)';

// ==== Hitung total halaman ====
$totalPages = ($limit > 0) ? ceil($total / $limit) : 1;

// ==== Output JSON ====
echo json_encode([
  'success'     => true,
  'data'        => $data,
  'class_name'  => $class_name,
  'total'       => $total,
  'limit'       => $limit,
  'page'        => $page,
  'total_pages' => $totalPages
], JSON_UNESCAPED_UNICODE);

exit;
?>
