<?php
ob_start(); // Cegah output HTML bocor
error_reporting(0);
ini_set('display_errors', 0);

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');

// ========== VALIDASI FILE & KELAS ==========
$class_id = (int) ($_POST['class_id'] ?? 0);
if (!$class_id) {
    ob_end_clean();
    echo json_encode(['success' => false, 'error' => '⚠️ Kelas belum dipilih.']);
    exit;
}

if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    ob_end_clean();
    echo json_encode(['success' => false, 'error' => '⚠️ File belum dipilih atau tidak valid.']);
    exit;
}

$ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
if ($ext !== 'csv') {
    ob_end_clean();
    echo json_encode(['success' => false, 'error' => '❌ Format file tidak didukung. Gunakan file CSV dari template.']);
    exit;
}
$cekKelas = $conn->query("SELECT id FROM classes WHERE id = $class_id");
if (!$cekKelas || $cekKelas->num_rows === 0) {
    echo json_encode(['success' => false, 'error' => '❌ Kelas tidak ditemukan atau tidak valid.']);
    exit;
}


$tmp = $_FILES['file']['tmp_name'];

// ========== BACA CSV ==========
$handle = fopen($tmp, "r");
if (!$handle) {
    ob_end_clean();
    echo json_encode(['success' => false, 'error' => '❌ Gagal membuka file CSV.']);
    exit;
}

// Deteksi otomatis delimiter (koma atau titik koma)
$firstLine = fgets($handle);
rewind($handle);
$delimiter = (substr_count($firstLine, ';') > substr_count($firstLine, ',')) ? ';' : ',';

$rows = [];
while (($data = fgetcsv($handle, 1000, $delimiter)) !== false) {
    $rows[] = $data;
}
fclose($handle);

if (count($rows) <= 1) {
    ob_end_clean();
    echo json_encode(['success' => false, 'error' => '⚠️ File kosong atau tidak sesuai format template.']);
    exit;
}

// ========== PROSES IMPOR ==========
$inserted = 0;
$duplicate = 0;

foreach ($rows as $i => $row) {
    if ($i === 0)
        continue; // skip header

    // pastikan jumlah kolom cukup
    if (count($row) < 5)
        continue;

    list($nim, $name, $birth, $email, $wa) = array_map('trim', $row);
    if (!$nim || !$name)
        continue;

    $nim = $conn->real_escape_string($nim);
    $name = $conn->real_escape_string($name);
    // Konversi tanggal ke format YYYY-MM-DD (jika valid)
    $birth = trim($birth);
    if ($birth) {
        // Coba ubah berbagai format umum (misal 01/02/2003, 1 Feb 2003, dst)
        $ts = strtotime(str_replace('/', '-', $birth));
        if ($ts && $ts > 0) {
            $birth = date('Y-m-d', $ts);
        } else {
            $birth = NULL; // invalid date
        }
    } else {
        $birth = NULL;
    }

    $email = $conn->real_escape_string($email);
    $wa = $conn->real_escape_string($wa);

    // cek duplikat per kelas
    $cek = $conn->query("SELECT id FROM students WHERE nim='$nim' AND class_id=$class_id");
    if ($cek && $cek->num_rows > 0) {
        $duplicate++;
        continue;
    }

    $q = "
    INSERT INTO students (class_id, nim, name, birth_date, email, whatsapp, created_at)
    VALUES ($class_id, '$nim', '$name', " . ($birth ? "'$birth'" : "NULL") . ", '$email', '$wa', NOW())
    ";

    if ($conn->query($q))
        $inserted++;
}

// ========== CATAT LOG ==========
$uid = $_SESSION['user_id'] ?? 0;
$logMsg = "📥 Mengimpor $inserted siswa ke kelas ID $class_id.";
if ($duplicate > 0)
    $logMsg .= " ($duplicate duplikat diabaikan)";
$conn->query("INSERT INTO logs (user_id, module, action, created_at)
              VALUES ($uid, 'siswa', '$logMsg', NOW())");

// ========== HASIL ==========
ob_end_clean(); // bersihkan semua output sebelum kirim JSON final

$message = "✅ Berhasil impor $inserted siswa.";
if ($duplicate > 0)
    $message .= " ⚠️ $duplicate data duplikat diabaikan.";

echo json_encode(['success' => true, 'message' => $message], JSON_UNESCAPED_UNICODE);
exit;
?>