<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
require_once __DIR__ . '/../../inc/config.php';

if (!canAccess('siswa', 'view')) {
  echo "<script>alert('Akses ditolak!');history.back();</script>";
  exit;
}

$title = "Data Siswa Per Kelas";
ob_start();

$kelas = $conn->query("
  SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  ORDER BY t.name, g.name, c.name
");

echo '<link rel="stylesheet" href="' . CSS_URL . '/style.css">';
echo '<script src="' . JS_URL . '/main.js"></script>';

?>

<?php load_assets(); ?>

<style>
/* === KHUSUS MOBILE: RAPIHIN LAYOUT DATA SISWA === */
@media (max-width: 768px) {
  .siswa-card-root {
    padding: 1rem;
    border-radius: 1rem;
  }

  .siswa-header-row {
    flex-direction: column;
    align-items: flex-start;
    gap: 0.5rem;
  }

  .siswa-filter-row {
    flex-direction: column;
    align-items: stretch;
    gap: 0.5rem;
    margin-top: 0.25rem;
  }

  .siswa-filter-row select,
  .siswa-filter-row button {
    width: 100%;
    font-size: 0.9rem;
  }

  .siswa-toolbar-row {
    flex-direction: column;
    align-items: flex-start;
    gap: 0.5rem;
  }

  .siswa-toolbar-row > div {
    flex-wrap: wrap;
    gap: 0.4rem;
  }

  .siswa-toolbar-row button {
    font-size: 0.75rem;
    padding-inline: 0.55rem;
    padding-block: 0.3rem;
  }

  .siswa-table-wrapper {
    margin-top: 0.75rem;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    border-radius: 0.75rem;
    border: 1px solid rgba(255,255,255,0.08);
  }

  #siswaTable {
    min-width: 850px; /* biar bisa di-swipe kanan-kiri, kolom tetap lengkap */
    font-size: 0.8rem;
  }

  #siswaTable th,
  #siswaTable td {
    padding: 0.4rem 0.5rem;
  }

  /* Kontrol bawah (limit & info) tetap enak di HP */
  #rowLimit {
    font-size: 0.8rem;
  }
}
</style>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10 relative siswa-card-root">
  <div class="flex justify-between items-center mb-4 siswa-header-row">
    <h1 class="text-xl font-semibold text-[#8CE0FF]">👨‍🎓 Data Siswa Per Kelas</h1>
  </div>

  <div class="flex gap-3 mb-4 siswa-filter-row">
    <select id="classSelect" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
      <option value="">-- Pilih Kelas --</option>
      <?php while ($c = $kelas->fetch_assoc()): ?>
        <option value="<?= $c['id'] ?>"><?= $c['class_name'] ?></option>
      <?php endwhile; ?>
    </select>
    <button onclick="loadSiswa()"
      class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded font-semibold hover:bg-[#8CE0FF] transition">
      Tampilkan
    </button>
  </div>

  <div id="siswaContainer" class="hidden">
    <div class="flex justify-between items-center mb-3">
      <h2 id="kelasTitle" class="text-lg text-[#8CE0FF] font-semibold">Daftar Siswa</h2>
    </div>
    <div class="flex justify-between items-center mb-3 siswa-toolbar-row">
      <div class="flex gap-2">
        <!-- Tombol Tambah -->
       <?php if (canAccess('siswa', 'add')): ?>
  <button onclick="openTambahModal()"
    class="bg-[#5B8CFF] text-[#0E1525] px-3 py-1 rounded font-semibold hover:bg-[#8CE0FF] transition">
    + Tambah
  </button>
<?php else: ?>
  <button onclick="noAccess('tambah')"
    class="bg-gray-500 text-[#0E1525] px-3 py-1 rounded font-semibold cursor-not-allowed">
    + Tambah
  </button>
<?php endif; ?>
        <!-- Tombol Impor -->
        <button onclick="openImportModal()"
          class="bg-[#4ADE80]/80 text-[#0E1525] px-3 py-1 rounded font-semibold hover:bg-[#4ADE80] transition">
          📥 Impor
        </button>
        <button onclick="exportSiswa()" class="bg-sky-600 hover:bg-sky-700 px-3 py-1 rounded text-sm">📤 Export</button>
        <button onclick="openLogModal()" class="bg-gray-600 hover:bg-gray-700 px-3 py-1 rounded text-sm">📋 Log
          Aktivitas</button>
        <button onclick="openBulkQRModal()" class="bg-[#007bff] hover:bg-[#0069d9] text-white px-3 py-1 rounded-md">
          Generate Durasi Masal
        </button>
        <button onclick="openRegenQRModal()" class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded-md">
          Regenerate QR Expired
        </button>
      </div>
    </div>

    <!-- WRAPPER TABEL: biar bisa di-scroll horizontal di HP -->
    <div class="siswa-table-wrapper">
      <table id="siswaTable" class="min-w-full text-sm text-[#B7C9E5]">
        <thead class="text-[#8CE0FF] border-b border-white/10">
          <tr>
            <th class="p-2 text-left">No</th>
            <th class="p-2 text-left">NIM</th>
            <th class="p-2 text-left">Nama</th>
            <th class="p-2 text-left">Tanggal Lahir</th>
            <th class="p-2 text-left">Email</th>
            <th class="p-2 text-left">WhatsApp</th>
            <th class="p-2 text-center">Aksi</th>
            <th class="p-2 text-center">QR</th>
          </tr>
        </thead>
        <tbody id="siswaBody">
          <tr>
            <td colspan="8" class="text-center text-[#92A2C2] p-3">
              Pilih kelas terlebih dahulu untuk menampilkan data.
            </td>
          </tr>
        </tbody>
      </table>
    </div>

    <!-- Kontrol Jumlah Data + Info Total + Pagination -->
    <div class="flex flex-col items-center justify-center mt-4 space-y-2">

      <div class="flex items-center">
        <label for="rowLimit" class="mr-2 text-sm text-gray-400">Tampilkan:</label>
        <select id="rowLimit" class="bg-[#1E293B] text-white text-sm px-3 py-1 rounded border border-white/10">
          <option value="25" selected>25</option>
          <option value="50">50</option>
          <option value="75">75</option>
          <option value="100">100</option>
        </select>
      </div>

      <p id="infoTotal" class="text-center text-sm text-gray-400"></p>

      <div id="pagination" class="flex justify-center gap-2"></div>
    </div>
  </div>
</div>

<!-- Modal Tambah Siswa -->
<div id="tambahModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-96 border border-white/10">
    <h2 class="text-xl text-[#8CE0FF] font-semibold mb-3">Tambah Siswa</h2>
    <input type="hidden" id="class_id">

    <label class="block text-[#B7C9E5] text-sm mb-1">NIM</label>
    <input type="text" id="nim" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Nama</label>
    <input type="text" id="name" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Tanggal Lahir</label>
    <input type="date" id="birth_date" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Email</label>
    <input type="email" id="email" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">WhatsApp</label>
    <input type="text" id="whatsapp" class="w-full p-2 mb-4 rounded bg-[#0E1525] border border-white/10"
      placeholder="08123456789">

    <div class="flex justify-end gap-2">
      <button onclick="closeTambahModal()" class="bg-gray-600 px-3 py-1 rounded">Batal</button>
      <button onclick="simpanSiswa()"
        class="bg-[#5B8CFF] text-[#0E1525] px-3 py-1 rounded font-semibold">Simpan</button>
    </div>
  </div>
</div>

<!-- Modal Import -->
<div id="importModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-96 border border-white/10 text-center">
    <h2 class="text-xl text-[#8CE0FF] font-semibold mb-3">📂 Impor Data Siswa</h2>
    <p class="text-[#B7C9E5] text-sm mb-3">Gunakan file template berikut untuk mengimpor data siswa:</p>
    <a href="download_template_siswa.php"
      class="inline-block bg-[#4ADE80]/80 text-[#0E1525] font-semibold px-3 py-1 rounded-lg mb-4 hover:bg-[#4ADE80] transition">
      📄 Unduh Template Excel
    </a>
    <input type="file" id="importFile" accept=".csv, .xlsx"
      class="block w-full text-sm text-[#B7C9E5] mb-4 cursor-pointer">
    <div class="flex justify-end gap-2">
      <button onclick="closeImportModal()" class="bg-gray-600 px-3 py-1 rounded">Batal</button>
      <button onclick="uploadImport()"
        class="bg-[#4ADE80]/80 text-[#0E1525] px-4 py-1 rounded font-semibold hover:bg-[#4ADE80] transition">
        Impor
      </button>
    </div>
  </div>
</div>

<!-- Modal Log Aktivitas -->
<div id="logModal" class="hidden fixed inset-0 bg-black/50 backdrop-blur-sm justify-center items-center z-50">
  <div class="bg-[#141C2F] w-[600px] p-5 rounded-xl shadow-xl border border-white/10">
    <h3 class="text-lg font-semibold mb-3">📋 Log Aktivitas Siswa</h3>
    <div id="logContent" class="max-h-[400px] overflow-y-auto text-sm text-[#C8D2E3] space-y-2">
      <p>Memuat data...</p>
    </div>
    <div class="text-right mt-4">
      <button onclick="closeLogModal()" class="bg-gray-700 hover:bg-gray-600 px-3 py-1 rounded">Tutup</button>
    </div>
  </div>
</div>

<!-- Modal Edit Siswa -->
<div id="editModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-96 border border-white/10">
    <h2 class="text-xl text-[#8CE0FF] font-semibold mb-3">Edit Siswa</h2>
    <input type="hidden" id="edit_id">
    <label class="block text-[#B7C9E5] text-sm mb-1">NIM</label>
    <input type="text" id="edit_nim" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Nama</label>
    <input type="text" id="edit_name" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Tanggal Lahir</label>
    <input type="date" id="edit_birth" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">Email</label>
    <input type="email" id="edit_email" class="w-full p-2 mb-3 rounded bg-[#0E1525] border border-white/10">

    <label class="block text-[#B7C9E5] text-sm mb-1">WhatsApp</label>
    <input type="text" id="edit_wa" class="w-full p-2 mb-4 rounded bg-[#0E1525] border border-white/10">

    <div class="flex justify-end gap-2">
      <button onclick="closeEditModal()" class="bg-gray-600 px-3 py-1 rounded">Batal</button>
      <button onclick="simpanEditSiswa()"
        class="bg-[#5B8CFF] text-[#0E1525] px-3 py-1 rounded font-semibold">Simpan</button>
    </div>
  </div>
</div>

<!-- Modal Atur Durasi QR -->
<div id="qrModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
  <div class="bg-[#1E293B] p-5 rounded-xl shadow-lg w-80">
    <h2 class="text-lg font-semibold text-white mb-3">Atur Durasi QR</h2>

    <input type="hidden" id="qrStudentId">

    <div class="space-y-2 text-sm text-gray-300">
      <button class="w-full py-1.5 bg-blue-600 hover:bg-blue-700 rounded" onclick="saveQRDuration(1)">1 Hari</button>
      <button class="w-full py-1.5 bg-blue-600 hover:bg-blue-700 rounded" onclick="saveQRDuration(3)">3 Hari</button>
      <button class="w-full py-1.5 bg-blue-600 hover:bg-blue-700 rounded" onclick="saveQRDuration(7)">7 Hari</button>
      <button class="w-full py-1.5 bg-green-600 hover:bg-green-700 rounded" onclick="saveQRDuration(9999)">Permanent</button>
      
      <div class="border-t border-gray-500 my-2"></div>
      <label class="block text-gray-400 text-xs">Pilih Tanggal Expired Manual:</label>
      <input type="date" id="manualDate" class="w-full bg-gray-800 text-gray-200 rounded p-1 text-sm">
      <button class="w-full py-1.5 bg-indigo-600 hover:bg-indigo-700 rounded mt-1" onclick="saveManualQR()">Simpan Manual</button>
    </div>

    <button onclick="closeQRModal()" class="mt-4 text-sm text-gray-400 hover:text-white w-full">Batal</button>
  </div>
</div>


<script>

console.log("JS Loaded ✅");

let currentPage = 1;

function loadSiswa(page = 1) {
  const classId = document.getElementById("classSelect").value;
  const limit = parseInt(document.getElementById("rowLimit")?.value || 25);

  if (!classId)
    return showToast("⚠️ Pilih kelas terlebih dahulu.", "warning");

  currentPage = page;

  fetch(`get_siswa.php?class_id=${classId}&limit=${limit}&page=${page}`)
    .then(async (r) => {
      const text = await r.text();
      try {
        return JSON.parse(text);
      } catch (err) {
        console.error("❌ JSON parse error:", err, "\nRaw response:", text);
        showToast("⚠️ Terjadi kesalahan data server.", "error");
        return { success: false, data: [] };
      }
    })
    .then((d) => {
      const tbody = document.getElementById("siswaBody");
      const container = document.getElementById("siswaContainer");
      const title = document.getElementById("kelasTitle");
      const pagination = document.getElementById("pagination");
      const info = document.getElementById("infoTotal");

      tbody.innerHTML = "";
      container.classList.remove("hidden"); // ⬅️ Pastikan container aktif selalu

      // === Jika gagal load data
      if (!d.success) {
        tbody.innerHTML = `<tr><td colspan="9" class="text-center text-red-400 p-3">
          Terjadi kesalahan memuat data siswa.
        </td></tr>`;
        title.innerText = "Daftar Siswa (Gagal memuat)";
        info.innerHTML = "";
        pagination.innerHTML = "";
        return;
      }

      // === Jika data kosong
      if (!d.data || d.data.length === 0) {
        tbody.innerHTML = `<tr><td colspan="9" class="text-center text-[#92A2C2] p-3">
          Belum ada siswa di kelas ini.
        </td></tr>`;
        title.innerText = "Daftar Siswa Kelas " + d.class_name;
        info.innerHTML = `Menampilkan 0 data — Halaman 1 dari 1 (0 siswa total)`;
        pagination.innerHTML = "";
        return;
      }

      // === Render data siswa
      d.data.forEach((s, i) => {
        // Cek izin akses berdasarkan hasil PHP (langsung dari session user)
        const canEdit = <?= canAccess('siswa', 'edit') ? 'true' : 'false' ?>;
        const canDelete = <?= canAccess('siswa', 'delete') ? 'true' : 'false' ?>;

        tbody.innerHTML += `
    <tr class="border-b border-white/5 hover:bg-[#0E1525]/60 transition">
      <td class="p-2">${i + 1 + (page - 1) * limit}</td>
      <td class="p-2">${s.nim}</td>
      <td class="p-2 font-semibold">${s.name}</td>
      <td class="p-2">${s.birth_date ? formatDate(s.birth_date) : "-"}</td>
      <td class="p-2">${s.email || "-"}</td>
      <td class="p-2">${s.whatsapp || "-"}</td>
      <td class="p-2 text-center">
        ${canEdit
          ? `<button onclick="editSiswa(${s.id})" class="text-[#5B8CFF] hover:underline">Edit</button>`
          : `<button onclick="noAccess('edit')" class="text-gray-500 cursor-not-allowed">Edit</button>`
        }
        |
        ${canDelete
          ? `<button onclick="hapusSiswa(${s.id})" class="text-red-400 hover:underline">Hapus</button>`
          : `<button onclick="noAccess('hapus')" class="text-gray-500 cursor-not-allowed">Hapus</button>`
        }
      </td>
      <td class="p-2 text-center">${s.qr_status || ""}</td>
    </tr>`;
      });
      // === Info dan pagination
      const total = d.total ?? d.data.length;
      const totalPages = Math.ceil(total / limit);
      title.innerText = "Daftar Siswa Kelas " + d.class_name;
      info.innerHTML = `Menampilkan <b>${limit}</b> data per halaman — Halaman <b>${page}</b> dari <b>${totalPages}</b> (${total} siswa total)`;
      pagination.innerHTML = `
        <button ${page <= 1 ? "disabled" : ""} 
          onclick="loadSiswa(${page - 1})" 
          class="px-3 py-1 bg-gray-700 text-white text-xs rounded mx-1 disabled:opacity-40">
          Sebelumnya
        </button>
        <button ${page >= totalPages ? "disabled" : ""} 
          onclick="loadSiswa(${page + 1})" 
          class="px-3 py-1 bg-blue-600 hover:bg-blue-700 text-white text-xs rounded mx-1 disabled:opacity-40">
          Berikutnya
        </button>`;

      document.getElementById("class_id").value = classId;
    })
    .catch((err) => {
      console.error("Error fetch siswa:", err);
      showToast("❌ Gagal memuat data siswa.", "error");
    });
}

// === Reload tabel kalau limit berubah ===
document.addEventListener("DOMContentLoaded", () => {
  const limitSelect = document.getElementById("rowLimit");
  if (limitSelect) limitSelect.addEventListener("change", () => loadSiswa(1));
});

function exportSiswa() {
  const classId = document.getElementById('classSelect').value;
  if (!classId) {
    showToast('⚠️ Pilih kelas terlebih dahulu sebelum mengekspor.', 'warning');
    return;
  }

  showToast('⏳ Sedang menyiapkan file...', 'info');
  window.location.href = `export_siswa.php?class_id=${classId}`;
}

// === Format tanggal ===
function formatDate(dateStr) {
  const date = new Date(dateStr);
  return date.toLocaleDateString("id-ID", {
    day: "2-digit",
    month: "short",
    year: "numeric",
  });
}

function openTambahModal() {
  ['nim', 'name', 'birth_date', 'email', 'whatsapp'].forEach(id => document.getElementById(id).value = '');
  document.getElementById('tambahModal').classList.replace('hidden', 'flex');
}

function closeTambahModal() {
  document.getElementById('tambahModal').classList.replace('flex', 'hidden');
}

// === SIMPAN SISWA (SUDAH BERJALAN NORMAL) ===
function simpanSiswa() {
  const classId = document.getElementById('class_id').value;
  const nim = document.getElementById('nim').value.trim();
  const name = document.getElementById('name').value.trim();
  const birth = document.getElementById('birth_date').value.trim();
  const email = document.getElementById('email').value.trim();
  const wa = document.getElementById('whatsapp').value.trim();

  if (!nim || !name) {
    showToast('❌ NIM dan Nama wajib diisi.', 'error');
    return;
  }

  fetch('save_siswa.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      'X-Requested-With': 'XMLHttpRequest'
    },
    body: `class_id=${classId}&nim=${encodeURIComponent(nim)}&name=${encodeURIComponent(name)}&birth_date=${encodeURIComponent(birth)}&email=${encodeURIComponent(email)}&whatsapp=${encodeURIComponent(wa)}`
  })
    .then(res => res.json())
    .then(d => {
      if (d.success) {
        closeTambahModal();
        showToast(d.message || '✅ Siswa berhasil ditambahkan!', 'success');
        loadSiswa();
      } else {
        showToast(d.error || '⚠️ NIM sudah ada.', 'warning');
      }
    })
    .catch(err => {
      console.error('Fetch error:', err);
      showToast('❌ Terjadi kesalahan sistem.', 'error');
    });
}

// === EDIT SISWA ===
function editSiswa(id) {
  fetch('get_siswa_detail.php?id=' + id)
    .then(r => r.json())
    .then(d => {
      if (!d.success) {
        showToast('❌ Data siswa tidak ditemukan.', 'error');
        return;
      }
      const s = d.data;
      document.getElementById('edit_id').value = s.id;
      document.getElementById('edit_nim').value = s.nim;
      document.getElementById('edit_name').value = s.name;
      document.getElementById('edit_birth').value = s.birth_date || '';
      document.getElementById('edit_email').value = s.email || '';
      document.getElementById('edit_wa').value = s.whatsapp || '';
      document.getElementById('editModal').classList.replace('hidden', 'flex');
    })
    .catch(() => showToast('⚠️ Gagal memuat data siswa.', 'warning'));
}

function closeEditModal() {
  document.getElementById('editModal').classList.replace('flex', 'hidden');
}

function simpanEditSiswa() {
  const id = document.getElementById('edit_id').value;
  const nim = document.getElementById('edit_nim').value.trim();
  const name = document.getElementById('edit_name').value.trim();
  const birth = document.getElementById('edit_birth').value.trim();
  const email = document.getElementById('edit_email').value.trim();
  const wa = document.getElementById('edit_wa').value.trim();

  if (!nim || !name) {
    showToast('⚠️ NIM dan Nama wajib diisi.', 'warning');
    return;
  }

  fetch('update_siswa.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      'X-Requested-With': 'XMLHttpRequest'
    },
    body: `id=${id}&nim=${encodeURIComponent(nim)}&name=${encodeURIComponent(name)}&birth_date=${encodeURIComponent(birth)}&email=${encodeURIComponent(email)}&whatsapp=${encodeURIComponent(wa)}`
  })
    .then(res => res.json())
    .then(d => {
      if (d.success) {
        closeEditModal();
        loadSiswa();
        showToast('✅ Data siswa berhasil diperbarui!', 'success');
      } else {
        showToast(d.error || '❌ Gagal menyimpan perubahan.', 'error');
      }
    })
    .catch(err => {
      console.error('Fetch error:', err);
      showToast('❌ Terjadi kesalahan sistem.', 'error');
    });
}

// === KONFIRMASI & HAPUS SISWA DENGAN NOTIFIKASI ===
function hapusSiswa(id) {
  // buat elemen konfirmasi
  const confirmBox = document.createElement('div');
  confirmBox.className = `
    fixed inset-0 bg-black/60 flex items-center justify-center z-[9999]
    animate-fadeIn
  `;
  confirmBox.innerHTML = `
    <div class="bg-[#141D2F] p-6 rounded-2xl border border-white/10 text-center shadow-xl w-[320px]">
      <h2 class="text-[#8CE0FF] font-semibold text-lg mb-2">Konfirmasi Hapus</h2>
      <p class="text-[#B7C9E5] text-sm mb-5">Apakah kamu yakin ingin menghapus siswa ini?</p>
      <div class="flex justify-center gap-3">
        <button id="cancelDel" class="bg-gray-600 hover:bg-gray-500 px-4 py-1 rounded-lg text-white font-medium transition">Batal</button>
        <button id="confirmDel" class="bg-red-600 hover:bg-red-500 px-4 py-1 rounded-lg text-white font-semibold transition">Hapus</button>
      </div>
    </div>
  `;
  document.body.appendChild(confirmBox);

  // tombol batal
  document.getElementById('cancelDel').onclick = () => confirmBox.remove();

  // tombol hapus
  document.getElementById('confirmDel').onclick = () => {
    fetch('delete_siswa.php?id=' + id)
      .then(r => r.json())
      .then(d => {
        confirmBox.remove();
        if (d.success) {
          loadSiswa();
          showToast('🗑️ Siswa berhasil dihapus.', 'success');
        } else {
          showToast('❌ Gagal menghapus siswa.', 'error');
        }
      })
      .catch(() => {
        confirmBox.remove();
        showToast('⚠️ Gagal menghapus siswa.', 'warning');
      });
  };
}

// animasi fade-in halus
const style = document.createElement('style');
style.textContent = `
@keyframes fadeIn {
  from { opacity: 0; transform: scale(0.95); }
  to { opacity: 1; transform: scale(1); }
}
.animate-fadeIn { animation: fadeIn 0.25s ease-out; }
`;
document.head.appendChild(style);

// === Modal Impor ===
function openImportModal() {
  document.getElementById('importFile').value = '';
  document.getElementById('importModal').classList.replace('hidden', 'flex');
}
function closeImportModal() {
  document.getElementById('importModal').classList.replace('flex', 'hidden');
}

// === Upload File & Proses Impor ===
function uploadImport() {
  const fileInput = document.getElementById('importFile');
  // Ambil langsung dari dropdown agar selalu akurat
  const classId = document.getElementById('classSelect').value;

  if (!fileInput.files.length)
    return showToast('⚠️ Pilih file terlebih dahulu.', 'warning');

  if (!classId)
    return showToast('⚠️ Pilih kelas terlebih dahulu sebelum impor.', 'warning');

  const file = fileInput.files[0];
  const ext = file.name.split('.').pop().toLowerCase();
  if (!['xlsx', 'csv'].includes(ext)) {
    showToast('❌ Format file tidak didukung. Gunakan template Excel (.xlsx atau .csv).', 'error');
    return;
  }

  const formData = new FormData();
  formData.append('class_id', classId);
  formData.append('file', file);

  showToast('⏳ Mengimpor data siswa...', 'info');

  fetch('import_siswa.php', {
    method: 'POST',
    body: formData
  })
    .then(r => r.json())
    .then(d => {
      if (d.success) {
        closeImportModal();
        loadSiswa();
        showToast(d.message || '✅ Data siswa berhasil diimpor!', 'success');
      } else {
        showToast(d.error || '❌ Gagal impor data.', 'error');
      }
    })
    .catch(err => {
      console.error('Error:', err);
      showToast('⚠️ Terjadi kesalahan sistem saat impor.', 'warning');
    });
}

function openLogModal() {
  const modal = document.getElementById('logModal');
  modal.classList.remove('hidden');
  modal.classList.add('flex');

  fetch('get_logs.php?module=siswa')
    .then(r => r.json())
    .then(d => {
      const box = document.getElementById('logContent');
      box.innerHTML = '';

      if (!d.success || !d.data || d.data.length === 0) {
        box.innerHTML = `<p class='text-center text-[#8492B7]'>Belum ada aktivitas.</p>`;
        return;
      }

      d.data.forEach(l => {
        box.innerHTML += `
          <div class="border-b border-white/5 py-1">
            <div class="text-xs text-[#A0AEC0] flex justify-between items-center">
              <span>${l.time}</span>
              <span class="text-[#5B8CFF] font-semibold">👤 ${l.operator}</span>
            </div>
            <div class="text-sm mt-0.5">${l.action}</div>
          </div>`;
      });
    })
    .catch(err => {
      console.error('Fetch log error:', err);
      document.getElementById('logContent').innerHTML =
        `<p class='text-red-400 text-center'>Gagal memuat log aktivitas.</p>`;
    });
}

function closeLogModal() {
  document.getElementById('logModal').classList.add('hidden');
  document.getElementById('logModal').classList.remove('flex');
}

function generateQR(id, duration = 1) {
  fetch(`generate_qr.php?id=${id}&duration=${duration}`)
    .then(r => r.json())
    .then(d => {
      if (d.success) {
        showToast(`✅ QR berhasil dibuat (aktif hingga ${d.expiry})`, 'success');
      } else {
        showToast(d.error || '❌ Gagal membuat QR.', 'error');
      }
    })
    .catch(() => showToast('⚠️ Gagal menghubungi server.', 'warning'));
}

function downloadQR(id) {
  fetch(`generate_qr.php?id=${id}&duration=1`)
    .then(r => r.json())
    .then(d => {
      if (d.success) {
        const link = document.createElement('a');
        link.href = d.qr_url;
        link.download = `QR_Siswa_${id}.png`;
        link.click();
      } else {
        showToast(d.error || '❌ Gagal mengunduh QR.', 'error');
      }
    });
}

function setQRDuration(id) {
  const dur = prompt("⏳ Berapa hari QR aktif?", "1");
  if (!dur || isNaN(dur)) return;
  fetch(`generate_qr.php?id=${id}&duration=${dur}`)
    .then(r => r.json())
    .then(d => {
      if (d.success) {
        showToast(`✅ QR baru aktif hingga ${d.expiry}`, 'success');
      } else {
        showToast(d.error || '❌ Gagal memperbarui QR.', 'error');
      }
    });
}

function generateAllQR() {
  if (!confirm("Yakin ingin generate ulang QR untuk semua siswa?")) return;
  document.querySelectorAll('button[onclick^="generateQR"]').forEach(btn => btn.click());
  showToast('🔄 Sedang generate QR untuk semua siswa...', 'info');
}

function setQRDuration(id) {
  document.getElementById('qrStudentId').value = id;
  document.getElementById('qrModal').classList.remove('hidden');
  document.getElementById('qrModal').classList.add('flex');
}

function closeQRModal() {
  document.getElementById('qrModal').classList.add('hidden');
  document.getElementById('qrModal').classList.remove('flex');
}

function saveQRDuration(days) {
  const id = document.getElementById('qrStudentId').value;
  fetch(`generate_qr.php?id=${id}&duration=${days}`)
    .then(r => r.json())
    .then(d => {
      closeQRModal();
      if (d.success) {
        showToast(`✅ QR aktif sampai ${d.expiry}`, 'success');
      } else {
        showToast(d.error || '❌ Gagal memperbarui QR.', 'error');
      }
    });
}

function saveManualQR() {
  const id = document.getElementById('qrStudentId').value;
  const manualDate = document.getElementById('manualDate').value;
  if (!manualDate) {
    showToast('⚠️ Pilih tanggal terlebih dahulu.', 'warning');
    return;
  }

  fetch(`generate_qr.php?id=${id}&manual_date=${manualDate}`)
    .then(r => r.json())
    .then(d => {
      closeQRModal();
      if (d.success) {
        showToast(`✅ QR aktif sampai ${d.expiry}`, 'success');
      } else {
        showToast(d.error || '❌ Gagal memperbarui QR.', 'error');
      }
    });
}

function openBulkQRModal() {
  const modal = `
  <div class="fixed inset-0 bg-black/60 flex items-center justify-center z-[9999]">
    <div class="bg-[#141D2F] p-6 rounded-xl shadow-xl text-center w-[340px]">
      <h2 class="text-[#8CE0FF] font-semibold mb-3">Generate QR Massal</h2>
      <p class="text-[#B7C9E5] mb-4 text-sm">Pilih durasi aktif QR untuk seluruh siswa kelas ini:</p>
      <div class="flex flex-col gap-2">
        <button onclick="generateAllQR(1)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">1 Hari</button>
        <button onclick="generateAllQR(3)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">3 Hari</button>
        <button onclick="generateAllQR(7)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">7 Hari</button>
        <button onclick="generateAllQR(9999)" class="bg-green-500 hover:bg-green-600 py-1 rounded-md text-white">Permanent</button>
      </div>
      <button onclick="this.parentElement.parentElement.remove()" class="mt-4 text-sm text-gray-400 hover:text-white">Batal</button>
    </div>
  </div>`;
  document.body.insertAdjacentHTML('beforeend', modal);
}

function generateAllQR(duration) {
  const classId = document.getElementById('classSelect').value;
  if (!classId) {
    alert('Pilih kelas terlebih dahulu.');
    return;
  }

  fetch(`generate_qr_bulk.php?class_id=${classId}&duration=${duration}`)
    .then(r => r.json())
    .then(d => {
      document.querySelector('.fixed.inset-0')?.remove();
      if (d.success) {
        alert(`✅ Berhasil membuat ${d.generated} QR.\nDurasi: ${d.expiry === 'Permanent' ? 'Permanent' : d.expiry}`);
      } else {
        alert(`❌ Gagal: ${d.error}`);
      }
    })
    .catch(() => alert('⚠️ Gagal memproses QR massal.'));
}

function openRegenQRModal() {
  const modal = `
  <div class="fixed inset-0 bg-black/60 flex items-center justify-center z-[9999]">
    <div class="bg-[#141D2F] p-6 rounded-xl shadow-xl text-center w-[340px]">
      <h2 class="text-[#8CE0FF] font-semibold mb-3">Regenerate QR Kadaluarsa</h2>
      <p class="text-[#B7C9E5] mb-4 text-sm">Pilih durasi baru untuk menggantikan QR yang sudah tidak aktif.</p>
      <div class="flex flex-col gap-2">
        <button onclick="regenExpiredQR(1)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">1 Hari</button>
        <button onclick="regenExpiredQR(3)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">3 Hari</button>
        <button onclick="regenExpiredQR(7)" class="bg-blue-500 hover:bg-blue-600 py-1 rounded-md text-white">7 Hari</button>
        <bu<td class="p-2 text-center"tton onclick="regenExpiredQR(9999)" class="bg-green-500 hover:bg-green-600 py-1 rounded-md text-white">Permanent</button>
      </div>
      <button onclick="this.parentElement.parentElement.remove()" class="mt-4 text-sm text-gray-400 hover:text-white">Batal</button>
    </div>
  </div>`;
  document.body.insertAdjacentHTML('beforeend', modal);
}

function regenExpiredQR(duration) {
  const classId = document.getElementById('classSelect').value;
  if (!classId) {
    alert('⚠️ Pilih kelas terlebih dahulu.');
    return;
  }

  fetch(`regenerate_expired_qr.php?class_id=${classId}&duration=${duration}`)
    .then(r => r.json())
    .then(d => {
      document.querySelector('.fixed.inset-0')?.remove();
      if (d.success) {
        alert(`✅ ${d.regenerated} QR berhasil diperbarui.\nDurasi: ${d.expiry}`);
      } else {
        alert(`❌ ${d.error}`);
      }
    })
    .catch(() => alert('⚠️ Gagal memperbarui QR.'));
}

// Tambah efek buka dropdown
document.querySelectorAll('select').forEach((sel) => {
  sel.addEventListener('mousedown', (e) => {
    sel.style.transition = 'all 0.25s ease';
    sel.style.transform = 'scale(1.02)';
    sel.style.boxShadow = '0 0 18px rgba(91, 140, 255, 0.35)';
  });
  sel.addEventListener('blur', () => {
    sel.style.transform = 'scale(1)';
    sel.style.boxShadow = 'none';
  });
});
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
?>
