<?php
error_reporting(0);
ini_set('display_errors', 0);
ob_clean();

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
require __DIR__ . '/../../vendor/phpqrcode/qrlib.php';

header('Content-Type: application/json; charset=utf-8');

$class_id = (int)($_GET['class_id'] ?? 0);
$duration = (int)($_GET['duration'] ?? 0);
if (!$class_id) {
  echo json_encode(['success' => false, 'error' => 'Kelas belum dipilih.']);
  exit;
}

// Hitung expired baru
if ($duration >= 9999) {
  $expireTime = null; // permanent
} else {
  $expireTime = date('Y-m-d H:i:s', strtotime("+$duration days"));
}

$dir = __DIR__ . '/../../qrcodes/';
if (!is_dir($dir)) mkdir($dir, 0777, true);

$baseURL = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}";
$q = $conn->query("
  SELECT id, nim, name, qr_expiry 
  FROM students 
  WHERE class_id = $class_id
  AND (qr_expiry IS NULL OR qr_expiry < NOW())
");

$regenerated = 0;
while ($r = $q->fetch_assoc()) {
  $nim = $r['nim'];
  $fileName = "{$nim}_" . time() . ".png";
  $filePath = $dir . $fileName;

  $url = "$baseURL/system-absent/modules/absensi_kelas/scan_qr.php?nim=" . urlencode($nim);
  QRcode::png($url, $filePath, QR_ECLEVEL_L, 6);

  $expireSQL = $expireTime ? "'$expireTime'" : "NULL";
  $conn->query("UPDATE students SET qr_expiry = $expireSQL WHERE id = {$r['id']}");
  $regenerated++;
}

$user_id = $_SESSION['user_id'] ?? 0;
$conn->query("INSERT INTO logs (user_id, module, action, created_at)
              VALUES ($user_id, 'siswa', '🔄 Regenerate QR Expired Kelas ID $class_id', NOW())");

echo json_encode([
  'success' => true,
  'regenerated' => $regenerated,
  'expiry' => $expireTime ? $expireTime : 'Permanent'
]);
exit;
?>
