<?php
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../../error_log.txt');
header('Content-Type: application/json; charset=utf-8');
session_start();

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

// ====== Ambil Data Input ======
$id    = (int)($_POST['id'] ?? 0);
$nim   = trim($conn->real_escape_string($_POST['nim'] ?? ''));
$name  = trim($conn->real_escape_string($_POST['name'] ?? ''));
$birth = trim($conn->real_escape_string($_POST['birth_date'] ?? ''));
$email = trim($conn->real_escape_string($_POST['email'] ?? ''));
$wa    = trim($conn->real_escape_string($_POST['whatsapp'] ?? ''));

if (!$id || !$nim || !$name) {
  echo json_encode(['success' => false, 'error' => '❌ NIM dan Nama wajib diisi.']);
  exit;
}

// ====== Ambil Data Lama ======
$old = $conn->query("SELECT * FROM students WHERE id=$id")->fetch_assoc();
if (!$old) {
  echo json_encode(['success' => false, 'error' => '⚠️ Data siswa tidak ditemukan.']);
  exit;
}

// ====== Proses Update ======
$q = "
UPDATE students 
SET 
  nim='$nim', 
  name='$name', 
  birth_date=" . ($birth ? "'$birth'" : "NULL") . ", 
  email='$email', 
  whatsapp='$wa'
WHERE id=$id
";

if ($conn->query($q)) {
  // Bandingkan perubahan
  $changes = [];
  foreach (['nim', 'name', 'birth_date', 'email', 'whatsapp'] as $col) {
    if ($old[$col] != $$col) {
      $changes[] = strtoupper($col) . ": " . ($old[$col] ?: '-') . " → " . ($$col ?: '-');
    }
  }

  // ====== Simpan Log ======
  $uid  = $_SESSION['user_id'] ?? 0;
  $log  = $changes ? implode(", ", $changes) : "Tidak ada perubahan data.";
  $desc = "✏️ Mengupdate siswa {$old['name']} ({$old['nim']}) — $log";

  $conn->query("
    INSERT INTO logs (user_id, module, action, created_at)
    VALUES ($uid, 'siswa', '$desc', NOW())
  ");

  echo json_encode(['success' => true, 'message' => '✅ Data siswa berhasil diperbarui!']);
} else {
  echo json_encode(['success' => false, 'error' => '❌ Gagal update data: '.$conn->error]);
}
?>
