<?php
require __DIR__.'/../../inc/auth.php';
if(!canAccess('user','edit')) {
  echo "<script>alert('Akses ditolak!');history.back();</script>";
  exit;
}

require __DIR__.'/../../inc/db.php';

$id = (int)($_GET['id'] ?? 0);
$user = $conn->query("SELECT * FROM users WHERE id=$id")->fetch_assoc();
if(!$user){
  echo "<script>alert('Data user tidak ditemukan');location='index.php';</script>";
  exit;
}

$title = "Edit User & Hak Akses";

// --- Simpan perubahan ---
if($_SERVER['REQUEST_METHOD']==='POST'){
  $nama = $_POST['nama'];
  $username = $_POST['username'];
  $tag = $_POST['tag'];
  $password = $_POST['password'];

  if(!empty($password)){
    $password = hash('sha256',$password);
    $conn->query("UPDATE users SET nama='$nama', username='$username', password='$password', tag='$tag' WHERE id=$id");
  } else {
    $conn->query("UPDATE users SET nama='$nama', username='$username', tag='$tag' WHERE id=$id");
  }

  // --- Update hak akses ---
  $conn->query("DELETE FROM user_access WHERE user_id=$id");

  if ($tag === 'Admin') {
    // Admin otomatis full akses
    $menusAll = $conn->query("SELECT id FROM menu_list");
    while($m = $menusAll->fetch_assoc()) {
      $mid = $m['id'];
      $conn->query("INSERT INTO user_access (user_id, menu_id, can_view, can_add, can_edit, can_delete)
                    VALUES ($id, $mid, 1,1,1,1)");
    }
  } else {
    if(!empty($_POST['access'])){
      foreach($_POST['access'] as $menu_id => $perms){
        $can_view   = isset($perms['view']) ? 1 : 0;
        $can_add    = isset($perms['add']) ? 1 : 0;
        $can_edit   = isset($perms['edit']) ? 1 : 0;
        $can_delete = isset($perms['delete']) ? 1 : 0;
        $conn->query("INSERT INTO user_access (user_id, menu_id, can_view, can_add, can_edit, can_delete)
                      VALUES ($id, $menu_id, $can_view, $can_add, $can_edit, $can_delete)");
      }
    }
  }

  echo "<script>alert('User dan hak akses berhasil diperbarui');location='index.php';</script>";
  exit;
}

// --- Ambil data menu ---
$menus = [];
$qmenu = $conn->query("SELECT * FROM menu_list ORDER BY menu_name");
while ($row = $qmenu->fetch_assoc()) { $menus[] = $row; }

$user_access = [];
$q = $conn->query("SELECT * FROM user_access WHERE user_id=$id");
while($r=$q->fetch_assoc()){ $user_access[$r['menu_id']]=$r; }

ob_start();
?>
<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10">
  <h1 class="text-2xl font-semibold mb-4">Edit User & Hak Akses</h1>

  <form method="POST" class="space-y-5" id="formUserAccess">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <label class="block text-sm text-[#92A2C2] mb-1">Nama Lengkap</label>
        <input type="text" name="nama" value="<?=htmlspecialchars($user['nama'])?>" required
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none">
      </div>
      <div>
        <label class="block text-sm text-[#92A2C2] mb-1">Username</label>
        <input type="text" name="username" value="<?=htmlspecialchars($user['username'])?>" required
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none">
      </div>
      <div>
        <label class="block text-sm text-[#92A2C2] mb-1">Password Baru (opsional)</label>
        <input type="password" name="password"
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none"
          placeholder="Kosongkan jika tidak diubah">
      </div>
      <div>
        <label class="block text-sm text-[#92A2C2] mb-1">Role / Tag</label>
        <select name="tag" id="tagSelect"
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none cursor-pointer">
          <option value="Admin" <?=$user['tag']=='Admin'?'selected':''?>>Admin</option>
          <option value="User" <?=$user['tag']=='User'?'selected':''?>>User</option>
        </select>
      </div>
    </div>

    <!-- Hak Akses -->
    <div class="mt-6">
      <div class="flex items-center justify-between mb-3">
        <h2 class="text-xl font-semibold">Hak Akses Menu</h2>
        <div class="flex gap-3">
          <label class="text-sm text-[#8CE0FF] cursor-pointer">
            <input type="checkbox" id="checkAllView" class="mr-1"> Semua View
          </label>
          <label class="text-sm text-[#8CE0FF] cursor-pointer">
            <input type="checkbox" id="checkAllAdd" class="mr-1"> Semua Add
          </label>
          <label class="text-sm text-[#8CE0FF] cursor-pointer">
            <input type="checkbox" id="checkAllEdit" class="mr-1"> Semua Edit
          </label>
          <label class="text-sm text-[#8CE0FF] cursor-pointer">
            <input type="checkbox" id="checkAllDelete" class="mr-1"> Semua Delete
          </label>
        </div>
      </div>

      <table class="w-full text-sm border-collapse" id="accessTable">
        <thead class="text-[#92A2C2] border-b border-white/10">
          <tr>
            <th class="text-center w-[50px]">
              <input type="checkbox" id="checkAllRows">
            </th>
            <th class="text-left py-2 px-3 w-1/3">Menu</th>
            <th class="text-center">View</th>
            <th class="text-center">Add</th>
            <th class="text-center">Edit</th>
            <th class="text-center">Delete</th>
          </tr>
        </thead>
        <tbody id="accessTableBody">
          <?php foreach($menus as $m): 
            $acc = $user_access[$m['id']] ?? ['can_view'=>0,'can_add'=>0,'can_edit'=>0,'can_delete'=>0];
          ?>
          <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="text-center">
              <input type="checkbox" class="checkRowMaster">
            </td>
            <td class="py-2 px-3"><?=$m['menu_label']?></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][view]"   <?=$acc['can_view']?'checked':''?>></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][add]"    <?=$acc['can_add']?'checked':''?>></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][edit]"   <?=$acc['can_edit']?'checked':''?>></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][delete]" <?=$acc['can_delete']?'checked':''?>></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="flex justify-end gap-3 mt-5">
      <a href="index.php" class="bg-gray-700 text-white px-4 py-2 rounded-lg hover:bg-gray-600">Batal</a>
      <button type="submit" class="bg-[#5B8CFF] text-[#0E1525] font-semibold px-5 py-2 rounded-lg hover:bg-[#8CE0FF] transition-all">
        Simpan Perubahan
      </button>
    </div>
  </form>
</div>

<script>
// === SELECT ALL PER KOLOM ===
['View','Add','Edit','Delete'].forEach(type => {
  document.getElementById('checkAll'+type).addEventListener('change', function(){
    document.querySelectorAll(`#accessTableBody input[name*="[${type.toLowerCase()}]"]`).forEach(cb => cb.checked = this.checked);
  });
});

// === SELECT ALL GLOBAL (kiri atas) ===
document.getElementById('checkAllRows').addEventListener('change', function(){
  document.querySelectorAll('#accessTableBody input[type="checkbox"]').forEach(cb => cb.checked = this.checked);
});

// === SELECT ALL PER MENU (kiri tiap baris) ===
document.querySelectorAll('.checkRowMaster').forEach(rowChk => {
  rowChk.addEventListener('change', function(){
    const row = this.closest('tr');
    row.querySelectorAll('input[type="checkbox"]').forEach(cb => {
      if (cb !== this) cb.checked = this.checked;
    });
  });
});

// === AUTO FULL AKSES UNTUK ADMIN ===
document.getElementById('tagSelect').addEventListener('change', function(){
  const isAdmin = this.value === 'Admin';
  document.querySelectorAll('#accessTable input[type="checkbox"]').forEach(cb => cb.checked = isAdmin);
});
</script>

<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
