<?php
// ===== File: modules/user/index.php =====
require __DIR__ . '/../../inc/auth.php';
logActivity('User', 'view');

// Cegah akses halaman tanpa izin view
if (!canAccess('user', 'view')) {
  echo "<script>alert('Akses ditolak!');history.back();</script>";
  exit;
}

$title = "Data User";
ob_start();
?>

<style>
/* === Notifikasi elegan top-center === */
#notif {
  position: fixed;
  top: 20px;
  left: 50%;
  transform: translateX(-50%);
  background: linear-gradient(135deg, #1B2338, #252E47);
  color: #E8EEFF;
  border: 1px solid #3B4A6B;
  padding: 12px 28px;
  border-radius: 12px;
  font-size: 14px;
  box-shadow: 0 4px 20px rgba(0,0,0,0.35);
  z-index: 9999;
  opacity: 0;
  pointer-events: none;
  transition: all .6s ease;
}
#notif.show {
  opacity: 1;
  transform: translateX(-50%) translateY(0);
}
</style>

<div id="notif"></div>

<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10">
  <div class="flex justify-between items-center mb-4">
    <h1 class="text-2xl font-semibold">Data User</h1>
    <button onclick="tambahUser()" 
      class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded-lg hover:bg-[#8CE0FF] font-semibold">
      + Tambah User
    </button>
  </div>

  <table class="w-full text-sm border-collapse">
    <thead class="text-[#92A2C2] border-b border-white/10">
      <tr>
        <th class="py-2 px-2 text-left">#</th>
        <th>Nama</th>
        <th>Username</th>
        <th>Tag</th>
        <th class="text-center">Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php
      require __DIR__ . '/../../inc/db.php';
      $no = 1;
      $q = $conn->query("SELECT * FROM users ORDER BY id ASC");
      while ($r = $q->fetch_assoc()):
      ?>
      <tr class="border-b border-white/5 hover:bg-white/5 transition">
        <td class="py-2 px-2"><?= $no++ ?></td>
        <td><?= htmlspecialchars($r['nama']) ?></td>
        <td><?= htmlspecialchars($r['username']) ?></td>
        <td><?= htmlspecialchars($r['tag']) ?></td>
        <td class="text-center space-x-2">
          <button onclick="editUser(<?= $r['id'] ?>)" class="text-yellow-400 hover:underline">Edit</button>
          <button onclick="hapusUser(<?= $r['id'] ?>)" class="text-red-400 hover:underline">Hapus</button>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<script>
// ===== Ambil izin user dari PHP =====
const canAddUser = <?= canAccess('user', 'add') ? 'true' : 'false' ?>;
const canEditUser = <?= canAccess('user', 'edit') ? 'true' : 'false' ?>;
const canDeleteUser = <?= canAccess('user', 'delete') ? 'true' : 'false' ?>;

// ===== Notifikasi custom top-center =====
function showNotif(message, type = 'warning') {
  const notif = document.getElementById('notif');
  notif.innerText = message;

  if (type === 'error') notif.style.background = 'linear-gradient(135deg, #3B1A1A, #471D1D)';
  else if (type === 'success') notif.style.background = 'linear-gradient(135deg, #1B3B2F, #2B5B47)';
  else notif.style.background = 'linear-gradient(135deg, #1B2338, #252E47)';

  notif.classList.add('show');
  setTimeout(() => notif.classList.remove('show'), 2500);
}

// ===== Fungsi tombol =====
function tambahUser() {
  if (!canAddUser) return showNotif('🚫 Kamu tidak memiliki izin untuk menambah user.');
  window.location.href = 'tambah.php';
}

function editUser(id) {
  if (!canEditUser) return showNotif('🚫 Kamu tidak memiliki izin untuk mengedit user.');
  window.location.href = 'edit.php?id=' + id;
}

function hapusUser(id) {
  if (!canDeleteUser) return showNotif('🚫 Kamu tidak memiliki izin untuk menghapus user.');

  if (confirm('Apakah kamu yakin ingin menghapus user ini?')) {
    window.location.href = 'hapus.php?id=' + id;
  }
}
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
?>
