<?php
require __DIR__.'/../../inc/auth.php';
logActivity('User', 'add');
if(!canAccess('user','add')) {
  echo "<script>alert('Akses ditolak!');history.back();</script>";
  exit;
}

require __DIR__.'/../../inc/db.php';
$title = "Tambah User";

// ==== SIMPAN USER (AJAX) ====
if($_SERVER['REQUEST_METHOD']==='POST'){
  header('Content-Type: application/json');

  $nama = trim($_POST['nama']);
  $username = trim($_POST['username']);
  $password_raw = $_POST['password'];
  $tag = $_POST['tag'];

  if($nama==='' || $username==='' || $password_raw===''){
    echo json_encode(['status'=>'error','notif'=>'Tidak boleh kosong!']); exit;
  }

  // Cek duplikat username
  $check = $conn->query("SELECT id FROM users WHERE username='$username'");
  if($check->num_rows > 0){
    echo json_encode(['status'=>'error','notif'=>'duplikat']); exit;
  }

  $password = hash('sha256',$password_raw);
  $sql = "INSERT INTO users (nama, username, password, tag) VALUES ('$nama','$username','$password','$tag')";
  if($conn->query($sql)){
    $newUserId = $conn->insert_id;

    // === Simpan Hak Akses ===
    if(!empty($_POST['access'])){
      foreach($_POST['access'] as $menu_id => $perms){
        $can_view   = isset($perms['view']) ? 1 : 0;
        $can_add    = isset($perms['add']) ? 1 : 0;
        $can_edit   = isset($perms['edit']) ? 1 : 0;
        $can_delete = isset($perms['delete']) ? 1 : 0;
        $conn->query("INSERT INTO user_access (user_id, menu_id, can_view, can_add, can_edit, can_delete)
                      VALUES ($newUserId, $menu_id, $can_view, $can_add, $can_edit, $can_delete)");
      }
    }

    // === Jika Role Admin → Auto semua akses ===
    if($tag === 'Admin'){
      $conn->query("DELETE FROM user_access WHERE user_id=$newUserId");
      $menus = $conn->query("SELECT id FROM menu_list");
      while($m = $menus->fetch_assoc()){
        $mid = $m['id'];
        $conn->query("INSERT INTO user_access (user_id, menu_id, can_view, can_add, can_edit, can_delete)
                      VALUES ($newUserId,$mid,1,1,1,1)");
      }
    }

    echo json_encode(['status'=>'success','notif'=>'berhasil']); exit;
  } else {
    echo json_encode(['status'=>'error','notif'=>'gagal']); exit;
  }
}

// === Live check username ===
if(isset($_GET['check'])){
  header('Content-Type: application/json');
  $u = trim($_GET['check']);
  $q = $conn->query("SELECT id FROM users WHERE username='$u'");
  echo json_encode(['exists'=>$q->num_rows>0]); exit;
}

// === Ambil Menu ===
$menus = [];
$q = $conn->query("SELECT * FROM menu_list ORDER BY menu_name");
while($r = $q->fetch_assoc()) $menus[] = $r;

ob_start();
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script src="https://kit.fontawesome.com/a2e0e6f6b5.js" crossorigin="anonymous"></script>

<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10 max-w-3xl mx-auto">
  <h1 class="text-2xl font-semibold mb-5">Tambah User Baru</h1>

  <form id="formTambahUser" class="space-y-6" autocomplete="off">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <!-- Nama Lengkap -->
      <div>
        <label class="block mb-1 text-sm text-[#92A2C2]">Nama Lengkap <span class="text-red-400">*</span></label>
        <input type="text" name="nama" id="nama"
          autocomplete="off" readonly onfocus="this.removeAttribute('readonly');"
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none"
          placeholder="Misal: Budi Santoso">
      </div>

      <!-- Username -->
      <div>
        <label class="block mb-1 text-sm text-[#92A2C2]">Username <span class="text-red-400">*</span></label>
        <input type="text" name="username" id="username" required
          autocomplete="off" readonly onfocus="this.removeAttribute('readonly');"
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none"
          placeholder="username">
        <p id="username-info" class="text-sm mt-1"></p>
      </div>

      <!-- Password -->
      <div class="relative">
        <label class="block mb-1 text-sm text-[#92A2C2]">Password <span class="text-red-400">*</span></label>
        <input type="password" name="password" id="password" required
          autocomplete="new-password" readonly onfocus="this.removeAttribute('readonly');"
          class="w-full p-2 pr-10 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none"
          placeholder="Password">
        <button type="button" id="togglePass"
          class="absolute right-2 top-[38px] text-[#92A2C2] hover:text-white">
          <i id="eyeIcon" class="fa-solid fa-eye"></i>
        </button>
      </div>

      <!-- Role -->
      <div>
        <label class="block mb-1 text-sm text-[#92A2C2]">Role / Tag</label>
        <select name="tag" id="tagSelect"
          class="w-full p-2 rounded bg-[#0E1525] border border-white/10 focus:border-[#5B8CFF] outline-none cursor-pointer">
          <option value="User">User</option>
          <option value="Admin">Admin</option>
        </select>
      </div>
    </div>

    <!-- Hak Akses -->
    <div>
      <h2 class="text-xl font-semibold mb-3">Hak Akses Menu</h2>
      <div class="flex gap-3 mb-3">
        <label class="text-sm text-[#8CE0FF] cursor-pointer"><input type="checkbox" id="checkAllView" class="mr-1"> Semua View</label>
        <label class="text-sm text-[#8CE0FF] cursor-pointer"><input type="checkbox" id="checkAllAdd" class="mr-1"> Semua Add</label>
        <label class="text-sm text-[#8CE0FF] cursor-pointer"><input type="checkbox" id="checkAllEdit" class="mr-1"> Semua Edit</label>
        <label class="text-sm text-[#8CE0FF] cursor-pointer"><input type="checkbox" id="checkAllDelete" class="mr-1"> Semua Delete</label>
      </div>

      <table class="w-full text-sm border-collapse">
        <thead class="text-[#92A2C2] border-b border-white/10">
          <tr>
            <th class="text-center w-[50px]"><input type="checkbox" id="checkAllRows"></th>
            <th class="text-left py-2 px-3">Menu</th>
            <th class="text-center">View</th>
            <th class="text-center">Add</th>
            <th class="text-center">Edit</th>
            <th class="text-center">Delete</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($menus as $m): ?>
          <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="text-center"><input type="checkbox" class="checkRowMaster"></td>
            <td class="py-2 px-3"><?= htmlspecialchars($m['menu_label']) ?></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][view]"></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][add]"></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][edit]"></td>
            <td class="text-center"><input type="checkbox" name="access[<?=$m['id']?>][delete]"></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="flex justify-end gap-3 mt-5">
      <a href="index.php" class="bg-gray-700 text-white px-4 py-2 rounded-lg hover:bg-gray-600">Batal</a>
      <button type="submit" class="bg-[#5B8CFF] text-[#0E1525] font-semibold px-5 py-2 rounded-lg hover:bg-[#8CE0FF] transition-all">
        Simpan
      </button>
    </div>
  </form>
</div>

<script>
// === Toggle Password ===
document.getElementById('togglePass').addEventListener('click', () => {
  const pass = document.getElementById('password');
  const eye = document.getElementById('eyeIcon');
  if(pass.type === 'password'){ pass.type='text'; eye.classList.replace('fa-eye','fa-eye-slash'); }
  else { pass.type='password'; eye.classList.replace('fa-eye-slash','fa-eye'); }
});

// === Role Admin → auto check semua ===
document.getElementById('tagSelect').addEventListener('change', function(){
  const isAdmin = this.value === 'Admin';
  document.querySelectorAll('tbody input[type="checkbox"]').forEach(cb => cb.checked = isAdmin);
});

// === Select All ===
function toggleAll(master, selector){ document.querySelectorAll(selector).forEach(cb => cb.checked = master.checked); }
document.getElementById('checkAllView').addEventListener('change', e => toggleAll(e.target,'input[name*="[view]"]'));
document.getElementById('checkAllAdd').addEventListener('change', e => toggleAll(e.target,'input[name*="[add]"]'));
document.getElementById('checkAllEdit').addEventListener('change', e => toggleAll(e.target,'input[name*="[edit]"]'));
document.getElementById('checkAllDelete').addEventListener('change', e => toggleAll(e.target,'input[name*="[delete]"]'));
document.getElementById('checkAllRows').addEventListener('change', e => {
  document.querySelectorAll('.checkRowMaster').forEach(row => row.checked = e.target.checked);
  document.querySelectorAll('tbody input[type="checkbox"]').forEach(cb => cb.checked = e.target.checked);
});

// === Checkbox per baris (otomatis centang view/add/edit/delete) ===
document.querySelectorAll('.checkRowMaster').forEach(rowChk => {
  rowChk.addEventListener('change', e => {
    const tr = e.target.closest('tr');
    if (!tr) return;
    tr.querySelectorAll('input[type="checkbox"]').forEach(cb => {
      if (cb !== rowChk) cb.checked = e.target.checked;
    });
  });
});

// === Live Cek Username ===
document.getElementById('username').addEventListener('input', () => {
  const val = document.getElementById('username').value.trim();
  const info = document.getElementById('username-info');
  if(val===''){ info.textContent=''; return; }
  fetch('?check='+encodeURIComponent(val))
    .then(r=>r.json())
    .then(d=>{
      if(d.exists){ info.textContent='⚠️ Username sudah digunakan'; info.className='text-red-400 text-sm mt-1'; }
      else { info.textContent='✅ Username tersedia'; info.className='text-green-400 text-sm mt-1'; }
    });
});

// === AJAX Submit tanpa reload ===
document.getElementById('formTambahUser').addEventListener('submit', e=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  fetch('',{method:'POST',body:fd})
    .then(r=>r.json())
    .then(d=>{
      showToast(d.notif);
      if(d.status==='success'){
        setTimeout(()=>{ window.location='index.php'; },2000);
      }
    });
});

function showToast(type){
  const opt = {duration:3000,gravity:"top",position:"center",style:{fontSize:"15px",borderRadius:"10px",color:"#fff"}};
  if(type==='berhasil') Toastify({...opt,text:"✅ User berhasil ditambahkan!",backgroundColor:"linear-gradient(to right,#00c6ff,#0072ff)"}).showToast();
  else if(type==='duplikat') Toastify({...opt,text:"⚠️ Username sudah digunakan!",backgroundColor:"linear-gradient(to right,#ff5f6d,#ffc371)"}).showToast();
  else if(type==='kosong') Toastify({...opt,text:"⚠️ Mohon isi semua kolom wajib!",backgroundColor:"linear-gradient(to right,#ff9966,#ff5e62)"}).showToast();
  else if(type==='gagal') Toastify({...opt,text:"❌ Gagal menambah user!",backgroundColor:"linear-gradient(to right,#f85032,#e73827)"}).showToast();
}
</script>

<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
