<?php
// ==============================================
// 📄 EXPORT REKAP PDF - PUBLIC VERSION
// ==============================================

ini_set('display_errors', 1);
error_reporting(E_ALL);

// ==============================================
// 🔗 KONEKSI DATABASE & DOMPDF
// ==============================================
$basePath = dirname(__DIR__); // -> /system-absent
require_once $basePath . '/inc/db.php';
require_once $basePath . '/vendor/autoload.php';

use Dompdf\Dompdf;

// ==============================================
// 🔐 VALIDASI TOKEN
// ==============================================
$token = $_GET['token'] ?? '';
if (!$token) {
  die('<h3 style="color:red;text-align:center;">❌ Token tidak ditemukan.</h3>');
}

$stmt = $conn->prepare("SELECT start, end, expired_at FROM rekap_public_links WHERE token = ? AND expired_at >= NOW()");
$stmt->bind_param('s', $token);
$stmt->execute();
$stmt->bind_result($start, $end, $expired_at);
if (!$stmt->fetch()) {
  die('<h3 style="color:red;text-align:center;">⚠️ Token tidak valid atau sudah kedaluwarsa.</h3>');
}
$stmt->close();

// ==============================================
// 🧾 SIAPKAN HTML UNTUK PDF
// ==============================================
$html = "
<style>
  body {
    font-family: 'DejaVu Sans', sans-serif;
    color: #222;
    font-size: 12px;
  }
  h2 {
    text-align: center;
    color: #333;
    margin-bottom: 5px;
  }
  h3 {
    background: #f0f4ff;
    padding: 6px 10px;
    border-left: 4px solid #5B8CFF;
    margin-top: 20px;
    font-size: 14px;
  }
  table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 8px;
  }
  th, td {
    border: 1px solid #999;
    padding: 6px;
    text-align: center;
  }
  th {
    background: #5B8CFF;
    color: #fff;
  }
  tr:nth-child(even) td {
    background: #f9f9f9;
  }
  .footer {
    margin-top: 20px;
    font-size: 11px;
    text-align: center;
    color: #555;
  }
</style>

<h2>📊 Rekap Absensi Siswa</h2>
<p style='text-align:center;'>Periode <b>$start</b> s.d. <b>$end</b></p>
";

// ==============================================
// 📚 LOOP SETIAP KELAS
// ==============================================
$q = $conn->query("
  SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  ORDER BY t.name, g.name, c.name
");

while ($kelas = $q->fetch_assoc()) {
  $html .= "<h3>{$kelas['class_name']}</h3>
  <table>
  <tr>
    <th>Nama</th>
    <th>Hadir</th>
    <th>Izin</th>
    <th>Sakit</th>
    <th>Alfa</th>
  </tr>";

  $sql = "
    SELECT s.name,
      SUM(CASE WHEN a.status='Hadir' THEN 1 ELSE 0 END) AS hadir,
      SUM(CASE WHEN a.status='Izin' THEN 1 ELSE 0 END) AS izin,
      SUM(CASE WHEN a.status='Sakit' THEN 1 ELSE 0 END) AS sakit,
      SUM(CASE WHEN a.status='Alfa' THEN 1 ELSE 0 END) AS alfa
    FROM students s
    LEFT JOIN attendance_daily a
      ON a.student_id = s.id
      AND a.tanggal BETWEEN ? AND ?
    WHERE s.class_id = ?
    GROUP BY s.id
  ";
  $st = $conn->prepare($sql);
  $st->bind_param('ssi', $start, $end, $kelas['id']);
  $st->execute();
  $res = $st->get_result();

  if ($res->num_rows === 0) {
    $html .= "<tr><td colspan='5'>Tidak ada data absensi</td></tr>";
  } else {
    while ($r = $res->fetch_assoc()) {
      $html .= "<tr>
        <td style='text-align:left'>{$r['name']}</td>
        <td style='color:green;font-weight:bold'>{$r['hadir']}</td>
        <td style='color:blue'>{$r['izin']}</td>
        <td style='color:orange'>{$r['sakit']}</td>
        <td style='color:red'>{$r['alfa']}</td>
      </tr>";
    }
  }
  $html .= "</table>";
}

$html .= "<div class='footer'>
  Dicetak otomatis pada " . date('d/m/Y H:i') . " WIB<br>
  <i>Link publik aktif hingga: " . date('d/m/Y H:i', strtotime($expired_at)) . " WIB</i>
</div>";

// ==============================================
// 🖨️ GENERATE PDF
// ==============================================
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Rekap_Absensi_{$start}_sd_{$end}.pdf", ["Attachment" => true]);
?>
