<?php
/**
 * 🔄 rekap_extend.php
 * Memperpanjang masa aktif link publik rekap absensi.
 * Dibuat agar respons langsung update di frontend tanpa reload & tanpa invalid date.
 */

header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/../inc/db.php';

// ===== Ambil parameter =====
$id   = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$days = isset($_GET['days']) ? (int)$_GET['days'] : 7;

if (!$id || $days < 1) {
  echo json_encode(['success' => false, 'error' => 'Parameter tidak valid.']);
  exit;
}

// ===== Cek data lama =====
$getOld = $conn->query("SELECT expired_at FROM rekap_public_links WHERE id = $id");
if (!$getOld || $getOld->num_rows === 0) {
  echo json_encode(['success' => false, 'error' => 'Data tidak ditemukan.']);
  exit;
}
$oldData = $getOld->fetch_assoc();
$expired_old = $oldData['expired_at'];

// ===== Update tanggal kadaluarsa =====
$update = $conn->query("UPDATE rekap_public_links SET expired_at = DATE_ADD(expired_at, INTERVAL $days DAY) WHERE id = $id");

if ($conn->affected_rows > 0) {
  // Ambil data baru setelah update
  $res = $conn->query("
    SELECT 
      DATE_FORMAT(expired_at, '%Y-%m-%dT%H:%i:%s+07:00') AS new_expired_at, 
      DATE_FORMAT(expired_at, '%d %b %Y %H:%i') AS formatted_display
    FROM rekap_public_links 
    WHERE id = $id
  ")->fetch_assoc();

  echo json_encode([
    'success'         => true,
    'message'         => "Berhasil diperpanjang $days hari.",
    'new_expired_at'  => $res['new_expired_at'],       // format ISO untuk JS
    'display'         => $res['formatted_display'],    // format cantik untuk tampilan tabel
    'expired_old'     => $expired_old,
    'days_added'      => $days
  ]);
} else {
  echo json_encode(['success' => false, 'error' => 'Gagal memperpanjang.']);
}
exit;
