<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

// ===== KONEKSI DATABASE =====
require_once __DIR__ . '/../inc/db.php';

// ===== PARAMETER =====
$token    = $_GET['token'] ?? '';
$class_id = isset($_GET['class_id']) ? (int)$_GET['class_id'] : 0;

// ===== VALIDASI TOKEN =====
if (!$token) {
  echo json_encode(['success' => false, 'error' => '❌ Token tidak ditemukan.']);
  exit;
}

$stmt = $conn->prepare("
  SELECT start, end, expired_at, use_period 
  FROM rekap_public_links 
  WHERE token = ?
");
$stmt->bind_param('s', $token);
$stmt->execute();
$link = $stmt->get_result()->fetch_assoc();

if (!$link) {
  echo json_encode(['success' => false, 'error' => '❌ Token tidak valid.']);
  exit;
}

if (strtotime($link['expired_at']) < time()) {
  echo json_encode(['success' => false, 'error' => '⚠️ Link sudah kedaluwarsa.']);
  exit;
}

// ===== MODE: LIST KELAS =====
if (!$class_id) {
  $kelas = $conn->query("
    SELECT 
      c.id, 
      CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
    FROM classes c
    LEFT JOIN class_tiers  t ON c.tier_id  = t.id
    LEFT JOIN class_groups g ON c.group_id = g.id
    ORDER BY t.name, g.name, c.name
  ")->fetch_all(MYSQLI_ASSOC);

  echo json_encode([
    'success' => true,
    'mode'    => 'list_class',
    'periode' => [
      'start'      => $link['start'],
      'end'        => $link['end'],
      'expired_at' => $link['expired_at'],
      'use_period' => (int)$link['use_period']
    ],
    'kelas' => $kelas
  ]);
  exit;
}

// ===== MODE: PERIODE / BULAN-TAHUN =====
$bulan = isset($_GET['bulan']) ? (int)$_GET['bulan'] : 0;
$tahun = isset($_GET['tahun']) ? (int)$_GET['tahun'] : 0;

if (isset($link['use_period']) && (int)$link['use_period'] === 0) {
  $bulan = $bulan ?: date('n');
  $tahun = $tahun ?: date('Y');
  $start = sprintf('%04d-%02d-01', $tahun, $bulan);
  $end   = date('Y-m-t', strtotime($start));
} else {
  $start = $link['start'];
  $end   = $link['end'];
}

// ===================================================
// 🗓️ MODE: REKAP PER TANGGAL
// ===================================================

$tanggal_stmt = $conn->prepare("
  SELECT DISTINCT DATE(a.tanggal) AS tanggal
  FROM attendance_daily a
  INNER JOIN students s ON s.id = a.student_id
  WHERE s.class_id = ? 
    AND a.tanggal BETWEEN ? AND ?
  ORDER BY tanggal ASC
");
$tanggal_stmt->bind_param("iss", $class_id, $start, $end);
$tanggal_stmt->execute();
$tanggal_result = $tanggal_stmt->get_result();

$rekap = [];

while ($tgl = $tanggal_result->fetch_assoc()) {
  $tanggal = $tgl['tanggal'];

  // ===============================
  // 🔥 EVENT SUPPORT DITAMBAHKAN
  // ===============================
  $stmt2 = $conn->prepare("
    SELECT 
      s.name,
      COALESCE(a.status, '-') AS status,
      act.name AS activity_name,
      qr.event_name AS event_name
    FROM students s
    LEFT JOIN attendance_daily a 
      ON a.student_id = s.id 
     AND DATE(a.tanggal) = ?
    LEFT JOIN activities act
      ON act.id = a.activity_id
    LEFT JOIN attendance_qr qr
      ON qr.id = a.qr_id
    WHERE s.class_id = ?
    ORDER BY s.name
  ");
  $stmt2->bind_param('si', $tanggal, $class_id);
  $stmt2->execute();
  $result = $stmt2->get_result();

  $data_per_tanggal = [];

  while ($row = $result->fetch_assoc()) {

    // ===============================
    // 🔥 PRIORITAS NAMA KEGIATAN
    // EVENT > ACTIVITY > KOSONG
    // ===============================
    $nama_kegiatan = '';
    if (!empty($row['event_name'])) {
      $nama_kegiatan = $row['event_name'];
    } elseif (!empty($row['activity_name'])) {
      $nama_kegiatan = $row['activity_name'];
    }

    $data_per_tanggal[] = [
      'name'          => $row['name'],
      'status'        => $row['status'],
      'activity_name' => $nama_kegiatan
    ];
  }

  $rekap[$tanggal] = $data_per_tanggal;
}

// ===================================================
// RESPONSE JSON
// ===================================================
echo json_encode([
  'success' => true,
  'mode'    => 'rekap_per_tanggal',
  'periode' => [
    'start'      => $start,
    'end'        => $end,
    'expired_at' => $link['expired_at'],
    'use_period' => (int)$link['use_period']
  ],
  'rekap' => $rekap
], JSON_PRETTY_PRINT);
