<?php
require __DIR__ . '/../inc/db.php';
header('Content-Type: application/json; charset=utf-8');

$start = $_GET['start'] ?? date('Y-m-01');
$end   = $_GET['end']   ?? date('Y-m-t');

ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!$conn) {
  echo json_encode(['success' => false, 'error' => 'Database tidak terhubung']);
  exit;
}

// ✅ Versi PER KELAS, pakai jumlah kegiatan per kelas per bulan
$sql = "
  SELECT 
    c.name AS kelas,
    MONTH(a.tanggal) AS bulan,
    COUNT(CASE WHEN a.status = 'Hadir' THEN 1 END) AS total_hadir,
    COUNT(DISTINCT DATE(a.tanggal)) AS total_kegiatan,
    (SELECT COUNT(*) FROM students s WHERE s.class_id = c.id) AS total_siswa,
    ROUND(
      (
        COUNT(CASE WHEN a.status = 'Hadir' THEN 1 END) /
        (
          (SELECT COUNT(*) FROM students s WHERE s.class_id = c.id) * 
          NULLIF(COUNT(DISTINCT DATE(a.tanggal)), 0)
        )
      ) * 100, 1
    ) AS persen
  FROM attendance_daily a
  LEFT JOIN classes c ON a.class_id = c.id
  WHERE a.tanggal BETWEEN ? AND ?
  GROUP BY c.name, MONTH(a.tanggal)
  ORDER BY c.name, MONTH(a.tanggal)
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
  echo json_encode(['success' => false, 'error' => 'Prepare gagal: ' . $conn->error]);
  exit;
}

$stmt->bind_param('ss', $start, $end);
$stmt->execute();
$res = $stmt->get_result();

$data = [];

while ($row = $res->fetch_assoc()) {
  $kelas = $row['kelas'];

  if (!isset($data[$kelas])) {
    $data[$kelas] = [];
  }

  $data[$kelas][] = [
    'bulan'  => (int)$row['bulan'],
    'hadir'  => (int)$row['total_hadir'],
    'persen' => (float)($row['persen'] ?? 0),
  ];
}

echo json_encode([
  'success' => true,
  'data'    => $data
]);
