<?php

session_start();


$token = trim($_GET['token'] ?? '');

// Kode error dari redirect (misal: invalid_token)
$errorCode = trim($_GET['err'] ?? '');

if ($token !== '') {
  $_SESSION['qr_token_rutin'] = $token;

  // Redirect ke URL PUBLIK (bukan file fisik)
  header("Location: /input-absensi");
  exit;
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Masuk Absensi Kegiatan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="icon" type="image/png" href="/system-absent/assets/icons/logo.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      min-height: 100vh;
      margin: 0;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Inter", sans-serif;
      background:
        radial-gradient(circle at top left, #0ea5e9 0, transparent 50%),
        radial-gradient(circle at bottom right, #22c55e 0, transparent 55%),
        #020617;
      color: #e5e7eb;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 1.5rem 1rem;
    }

    /* TOAST */
    #toast {
      position: fixed;
      top: 0.9rem;
      left: 50%;
      transform: translate(-50%, -16px);
      width: min(95%, 420px);
      z-index: 50;
      opacity: 0;
      pointer-events: none;
      transition: opacity .25s ease-out, transform .25s ease-out;
    }
    #toast.show {
      opacity: 1;
      transform: translate(-50%, 0);
      pointer-events: auto;
    }

    /* LOADING OVERLAY */
    #loadingOverlay {
      position: fixed;
      inset: 0;
      background: rgba(15, 23, 42, 0.78);
      backdrop-filter: blur(6px);
      display: none;
      align-items: center;
      justify-content: center;
      z-index: 40;
    }
    #loadingOverlay.show {
      display: flex;
    }
  </style>
</head>
<body data-error="<?php echo htmlspecialchars($errorCode, ENT_QUOTES, 'UTF-8'); ?>">

  <!-- LOADING SPINNER -->
  <div id="loadingOverlay">
    <div class="flex flex-col items-center gap-3">
      <div class="w-14 h-14 rounded-full border-2 border-sky-400/30 border-t-sky-400 animate-spin"></div>
      <p class="text-xs text-slate-300 tracking-wide">Menghubungkan ke halaman absensi...</p>
    </div>
  </div>

  <!-- TOAST -->
  <div id="toast">
    <div id="toastInner"
         class="flex items-center gap-3 px-4 py-2.5 rounded-2xl shadow-2xl border text-sm
                bg-slate-900/95 border-slate-600/80 text-slate-50 backdrop-blur-xl">
      <div id="toastIcon"
           class="w-8 h-8 rounded-full flex items-center justify-center text-lg bg-slate-800/90">
        !
      </div>
      <div class="flex-1">
        <p id="toastTitle" class="font-semibold mb-0.5">Info</p>
        <p id="toastText" class="text-[12px] leading-snug text-slate-200"></p>
      </div>
    </div>
  </div>

  <!-- CARD -->
  <main class="w-full max-w-md">
    <div class="bg-slate-900/80 border border-slate-700/80 rounded-3xl shadow-[0_24px_80px_rgba(15,23,42,0.85)] px-7 py-7">
      <div class="flex items-center gap-3 mb-5">
        <div class="w-10 h-10 rounded-2xl bg-gradient-to-tr from-blue-500 to-sky-400 flex items-center justify-center shadow-lg">
          <span class="text-xl">🔐</span>
        </div>
        <div>
          <p class="text-[11px] uppercase tracking-[0.16em] text-slate-400">
            System Absent • Idea-Proper
          </p>
          <h1 class="text-lg sm:text-xl font-semibold text-slate-50">
            Masuk Absensi Kegiatan
          </h1>
        </div>
      </div>

      <!-- submit ke URL yang sama: /attandance -->
      <form id="tokenForm" method="get" class="space-y-4">
        <div>
          <label for="token" class="block text-sm text-slate-100 mb-1.5">Token Absen</label>
          <div class="relative">
            <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-sky-400 text-sm">
              🔑
            </span>
            <input
              type="text"
              id="token"
              name="token"
              required
              autocomplete="off"
              class="w-full rounded-2xl pl-9 pr-3 py-2.5 bg-slate-900/80 text-slate-50 text-sm
                     border border-slate-700 focus:outline-none focus:ring-2 focus:ring-sky-500
                     focus:border-sky-400 placeholder:text-slate-500"
              placeholder="contoh: 6a415f65e">
          </div>
        <p class="text-[11px] text-slate-400 mt-2 text-left">
  Jika tidak memiliki token,
  <a href="https://wa.me/6282332661126"
     target="_blank"
     rel="noopener noreferrer"
     class="text-slate-100 font-medium underline underline-offset-2 hover:text-emerald-300 transition">
    hubungi admin
  </a>.
</p>

        </div>

        <button
          type="submit"
          class="w-full mt-2 py-2.5 rounded-2xl bg-gradient-to-r from-sky-500 via-blue-600 to-indigo-600
                 hover:from-sky-400 hover:via-blue-500 hover:to-indigo-500 text-sm font-semibold
                 text-white shadow-lg shadow-sky-900/60 flex items-center justify-center gap-2
                 transition-all duration-200">
          <span>Masuk ke Halaman Absen</span>
          <span class="text-base">↗</span>
        </button>
      </form>

      <p class="mt-4 text-[11px] text-slate-500 leading-relaxed border-t border-slate-800 pt-3">
        Dengan menggunakan halaman ini, kamu menyetujui pencatatan kehadiran sesuai ketentuan sekolah.
      </p>
    </div>

    <p class="mt-4 text-[10px] text-center text-slate-500">
      © <?php echo date('Y'); ?> <span class="text-sky-400 font-medium">System Absent</span>. All rights reserved.
    </p>
  </main>

  <script>
    // ===== TOAST UTIL =====
    function showToast(type, title, message) {
      const toast    = document.getElementById('toast');
      const iconBox  = document.getElementById('toastIcon');
      const titleEl  = document.getElementById('toastTitle');
      const textEl   = document.getElementById('toastText');
      const inner    = document.getElementById('toastInner');

      let icon  = "ℹ️";
      let bg    = "linear-gradient(135deg,#0f172a,#020617)";
      let border= "#64748b";

      if (type === "error") {
        icon   = "✖";
        bg     = "linear-gradient(135deg,#b91c1c,#ef4444)";
        border = "#f97373";
      } else if (type === "success") {
        icon   = "✅";
        bg     = "linear-gradient(135deg,#15803d,#22c55e)";
        border = "#4ade80";
      } else if (type === "warning") {
        icon   = "⚠️";
        bg     = "linear-gradient(135deg,#b45309,#f59e0b)";
        border = "#fbbf24";
      }

      iconBox.textContent     = icon;
      inner.style.background  = bg;
      inner.style.borderColor = border;
      titleEl.textContent     = title;
      textEl.textContent      = message;

      toast.classList.add('show');
      setTimeout(() => toast.classList.remove('show'), 3500);
    }

    // ===== LOADING ON SUBMIT =====
    const form = document.getElementById('tokenForm');
    const loadingOverlay = document.getElementById('loadingOverlay');

    form.addEventListener('submit', () => {
      // Tampilkan loading ketika submit, biarkan browser melakukan redirect normal
      loadingOverlay.classList.add('show');
    });

    // ===== TAMPILKAN ERROR DARI BACKEND (TOKEN SALAH) =====
    document.addEventListener('DOMContentLoaded', () => {
      const errCode = document.body.dataset.error;
      if (errCode === 'invalid_token') {
        showToast(
          'error',
          'Token tidak ditemukan',
          'Periksa kembali token absen yang kamu masukkan atau hubungi admin untuk memastikan token masih aktif.'
        );
      }
    });
  </script>
</body>
</html>
