<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    $targetDir = __DIR__ . '/../../uploads/';
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    $fileName = 'logo_lembaga.png';
    $targetFile = $targetDir . $fileName;

    $check = getimagesize($_FILES["logo"]["tmp_name"]);
    if ($check !== false) {
        if (move_uploaded_file($_FILES["logo"]["tmp_name"], $targetFile)) {
            $msg = "<div class='p-3 rounded bg-green-600 text-white text-center'>✅ Logo berhasil diunggah!</div>";
        } else {
            $msg = "<div class='p-3 rounded bg-red-600 text-white text-center'>❌ Gagal mengunggah logo.</div>";
        }
    } else {
        $msg = "<div class='p-3 rounded bg-yellow-600 text-white text-center'>⚠️ File bukan gambar valid.</div>";
    }
}
?>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10">
  <h1 class="text-xl font-semibold text-[#8CE0FF] mb-4">🖼️ Upload Logo Lembaga</h1>
  <?=$msg?>
  <form method="POST" enctype="multipart/form-data" class="space-y-3">
    <input type="file" name="logo" accept="image/*" required class="block w-full p-2 bg-[#0E1525] text-[#B7C9E5] border border-white/10 rounded">
    <button type="submit" class="bg-[#37F297] text-[#0E1525] font-semibold px-4 py-2 rounded hover:bg-[#5BFFD9] transition">Upload Logo</button>
  </form>

  <?php
  $logoPath = __DIR__ . '/../../uploads/logo_lembaga.png';
  if (file_exists($logoPath)) {
      echo "<div class='mt-4 text-center'><p class='text-[#8CE0FF] mb-2'>Logo aktif:</p><img src='../../uploads/logo_lembaga.png' alt='Logo' class='mx-auto w-32 rounded shadow-lg'></div>";
  }
  ?>
</div>
