<?php
/**
 * Manual Autoload mPDF tanpa Composer
 * Created by Farhan & GPT 😎
 */

spl_autoload_register(function ($class) {
    // Pastikan hanya untuk namespace Mpdf
    if (strpos($class, 'Mpdf\\') !== 0) {
        return;
    }

    // Ubah namespace ke path file
    $path = str_replace('\\', DIRECTORY_SEPARATOR, $class);
    $file = __DIR__ . '/' . strtolower($path) . '.php';

    // Beberapa versi mPDF pakai huruf besar di folder src/
    if (!file_exists($file)) {
        $file = __DIR__ . '/' . $path . '.php';
    }

    // Coba juga di folder src (kebanyakan file utama di sana)
    if (!file_exists($file)) {
        $file = __DIR__ . '/mpdf/src/' . str_replace('Mpdf\\', '', $class) . '.php';
    }

    if (file_exists($file)) {
        require_once $file;
    } else {
        error_log("Autoload gagal: file untuk class $class tidak ditemukan di $file");
    }
});
?>
